package generalplus.com.GPComAir5Demo;

import generalplus.com.GPComAir5Demo.R;
import generalplus.com.GPLib.ComAir5Wrapper;
import generalplus.com.GPLib.ComAir5Wrapper.*;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.AsyncTask;
import android.os.Bundle;
import android.app.Activity;
import android.content.pm.ActivityInfo;
import android.util.Log;
import android.view.Menu;
import android.view.View;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.ScrollView;
import android.widget.TabHost;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.ToggleButton;

public class MainActivity extends Activity {
	
	private ComAir5Wrapper m_ComAir5 = new ComAir5Wrapper();
	private static String DBGTag = "GPComAir5MainActivity";
	
	private MediaPlayer mPlayer = null;
	private TabHost mTabHost;
	private ScrollView scrollView1;
	private ProgressBar progressBar1;
	private ToggleButton toggleButton_Decode_Record, toggleButton_Encode_AutoTest, toggleButton_Settings_SaveRawData;
	private TextView textView_Decode_Command, textView_Decode_HistoryCommand, textView_Encode_Command;
	private Button button_Encode_Minus, button_Encode_Plus, button_Encode_Send, button_Settings_Set, button_Calibrate_Recorder;
	private EditText editText_Settings_CentralFreq, editText_Settings_idf, editText_Settings_threshold;
	private boolean bTxMode = false;
	
	int i32Cmd, i32Count, i32StatusValue;
	AutoRunTest autoRunTest;
	String rstString; 
	DisplayCommandValueHelper displayHelper = new DisplayCommandValueHelper() {

		@Override
		public void getCommand(int count, int cmdValue, int statusValue) {
			i32Cmd = cmdValue;
			i32Count = count;
			i32StatusValue = statusValue;
			
			if(eComAir5Status.eComAir5Status_CalibrationProcessSuccess.getVal() == i32StatusValue)
				rstString = textView_Decode_HistoryCommand.getText() + "\n" + "ComAir5 Calibration Process is successful. Type: " + m_ComAir5.GetComAir5RecorderType();
			else if(eComAir5Status.eComAir5Status_CalibrationProcessFailed.getVal() == i32StatusValue)
				rstString = textView_Decode_HistoryCommand.getText() + "\n" + "ComAir5 Calibration Process is failed. (All types are failed)";
			else if(eComAir5Status.eComAir5Status_RecorderInitializationFailed.getVal() == i32StatusValue)
				rstString = textView_Decode_HistoryCommand.getText() + "\n" + "The recorder is not initialized on type " + m_ComAir5.GetComAir5RecorderType();
			else if(eComAir5Status.eComAir5Status_CalibrationTypeFailed.getVal() == i32StatusValue)
				rstString = textView_Decode_HistoryCommand.getText() + "\n" + "Type " + m_ComAir5.GetComAir5RecorderType() + " is failed.";
			else
				rstString = "[" + i32Count + "] Command: " + i32Cmd + "\n" + textView_Decode_HistoryCommand.getText().toString();
						
			runOnUiThread(new Runnable(){

				@Override
				public void run() {	
					
					textView_Decode_HistoryCommand.setText(rstString);
					scrollView1.fullScroll(View.FOCUS_UP);
					
					if(eComAir5Status.eComAir5Status_DecodeCommand.getVal() == i32StatusValue)
						PlayCmdSound(i32Cmd);						
				}
				
			});
		}
		
	};	

	@Override
	public void onBackPressed() {
		// TODO Auto-generated method stub
		if(autoRunTest != null)
			autoRunTest.bRun = false;
		super.onBackPressed();
	}

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_BEHIND);// Screenlock
		m_ComAir5.SetDisplayCommandValueHelper(displayHelper);		
		mTabHost = (TabHost) findViewById(R.id.tabhost1);
		mTabHost.setup();
		TabHost.TabSpec spec1 = mTabHost.newTabSpec("tab1");
		spec1.setContent(R.id.decodeLayout);
		spec1.setIndicator("Decode", getResources().getDrawable(R.drawable.mic));
		mTabHost.addTab(spec1);
		TabHost.TabSpec spec2 = mTabHost.newTabSpec("tab2");
		spec2.setContent(R.id.encodeLayout);
		spec2.setIndicator("Encode", getResources().getDrawable(R.drawable.sound));
		mTabHost.addTab(spec2);
		TabHost.TabSpec spec3 = mTabHost.newTabSpec("tab3");
		spec3.setContent(R.id.settingsLayout);
		spec3.setIndicator("Settings", getResources().getDrawable(R.drawable.settings));
		mTabHost.addTab(spec3);	
		mTabHost.setCurrentTab(0);
		mTabHost.setOnTabChangedListener(new TabHost.OnTabChangeListener() {

			@Override
			public void onTabChanged(String arg0) {
				// TODO Auto-generated method stub
				
			}
			 
		});
		
		//Decode.xml
		progressBar1 = (ProgressBar)findViewById(R.id.progressBar1);
		toggleButton_Decode_Record = (ToggleButton)findViewById(R.id.toggleButton_Decode_Record);	
		toggleButton_Decode_Record.setOnCheckedChangeListener(new OnCheckedChangeListener(){

			@Override
			public void onCheckedChanged(CompoundButton buttonView,
					boolean isChecked) {
				bTxMode = isChecked;
				if(isChecked)
				{
					progressBar1.setVisibility(progressBar1.VISIBLE);
					m_ComAir5.StartComAir5DecodeProcess();
					textView_Decode_HistoryCommand.setText("");
					textView_Decode_Command.setText("");
				}
				else
				{
					progressBar1.setVisibility(progressBar1.INVISIBLE);
					m_ComAir5.StopComAir5DecodeProcess();
				}
				
			}
			
		});
		scrollView1 = (ScrollView)findViewById(R.id.scrollView1);
		textView_Decode_Command = (TextView)findViewById(R.id.textView_Decode_Command);
		textView_Decode_HistoryCommand = (TextView)findViewById(R.id.textView_Decode_HistoryCommand);
		button_Calibrate_Recorder = (Button)findViewById(R.id.button_Calibrate_Recorder);
		button_Calibrate_Recorder.setOnClickListener(new Button.OnClickListener(){

			@Override
			public void onClick(View v) {
				textView_Decode_HistoryCommand.setText("");
				toggleButton_Decode_Record.setChecked(false);
				progressBar1.setVisibility(progressBar1.INVISIBLE);
				m_ComAir5.StopComAir5DecodeProcess();
				m_ComAir5.CalibrateComAir5Recorder();				
			}
			
		});
		
		//Encode.xml
		toggleButton_Encode_AutoTest = (ToggleButton)findViewById(R.id.toggleButton_Encode_AutoTest);
		textView_Encode_Command = (TextView)findViewById(R.id.textView5);
		toggleButton_Encode_AutoTest.setOnCheckedChangeListener(new OnCheckedChangeListener(){

			@Override
			public void onCheckedChanged(CompoundButton buttonView,
					boolean isChecked) {
				if(isChecked)
				{
					autoRunTest = new AutoRunTest(true);
					autoRunTest.execute();
				}
				else
					autoRunTest.bRun = false;
			}
			
		});		
		button_Encode_Minus = (Button)findViewById(R.id.button_Encode_Minus);
		button_Encode_Minus.setOnClickListener(new Button.OnClickListener(){

			@Override
			public void onClick(View v) {
				int i32Cmd = Integer.valueOf(textView_Encode_Command.getText().toString());
				if(i32Cmd == 0)
					i32Cmd = 79;
				else
					i32Cmd = i32Cmd - 1;
				textView_Encode_Command.setText(Integer.toString(i32Cmd));
			}
			
		});
		button_Encode_Plus = (Button)findViewById(R.id.button_Encode_Plus);
		button_Encode_Plus.setOnClickListener(new Button.OnClickListener(){

			@Override
			public void onClick(View v) {
				int i32Cmd = Integer.valueOf(textView_Encode_Command.getText().toString());
				if(i32Cmd == 79)
					i32Cmd = 0;
				else
					i32Cmd = i32Cmd + 1;
				textView_Encode_Command.setText(Integer.toString(i32Cmd));				
			}
			
		});
		button_Encode_Send = (Button)findViewById(R.id.button_Encode_Send);
		button_Encode_Send.setOnClickListener(new Button.OnClickListener(){

			@Override
			public void onClick(View v) {
				if(!m_ComAir5.IsComAir5CmdPlaying())
				{				
					m_ComAir5.PlayComAirCmd(Integer.valueOf(textView_Encode_Command.getText().toString()), 1.0f);
					if(!bTxMode)
						PlayCmdSound(Integer.valueOf(textView_Encode_Command.getText().toString()));
					
					/*//Send Command List
					ComAir5Command[] cmdList = new ComAir5Command[18];
					for(int i=0;i<cmdList.length;i++)
						cmdList[i] = m_ComAir5. new ComAir5Command(i, 0.5f);
					m_ComAir5.PlayComAirCmdList(cmdList, 1.0f);
					cmdList = null;*/
				}
				else
					Toast.makeText(MainActivity.this, "The COMAIR5 is playing, please wait!", Toast.LENGTH_LONG ).show();
			}
			
		});
		
		//Settings.xml
		toggleButton_Settings_SaveRawData = (ToggleButton)findViewById(R.id.toggleButton_Settings_SaveRawData);
		toggleButton_Settings_SaveRawData.setOnCheckedChangeListener(new OnCheckedChangeListener(){

			@Override
			public void onCheckedChanged(CompoundButton buttonView,
					boolean isChecked) {
				if(isChecked)
					m_ComAir5.SetComAir5Property(ComAir5Wrapper.eComAir5PropertyTarget.eComAir5PropertyTarget_Decode.ordinal(), ComAir5Wrapper.eComAir5Property.eComAir5Property_SaveRawData.ordinal(), 1);	
				else
					m_ComAir5.SetComAir5Property(ComAir5Wrapper.eComAir5PropertyTarget.eComAir5PropertyTarget_Decode.ordinal(), ComAir5Wrapper.eComAir5Property.eComAir5Property_SaveRawData.ordinal(), 0);
			}
			
		});
		editText_Settings_CentralFreq = (EditText)findViewById(R.id.editText_Settings_CentralFreq);
		editText_Settings_idf = (EditText)findViewById(R.id.editText_Settings_idf);
		editText_Settings_threshold = (EditText)findViewById(R.id.editText_Settings_threshold);
		button_Settings_Set = (Button)findViewById(R.id.button_Settings_Set);
		button_Settings_Set.setOnClickListener(new Button.OnClickListener(){

			@Override
			public void onClick(View arg0) {			
				//Set Central Frequency to decode and encode.
				m_ComAir5.SetComAir5Property(ComAir5Wrapper.eComAir5PropertyTarget.eComAir5PropertyTarget_Decode.ordinal(), ComAir5Wrapper.eComAir5Property.eComAir5Property_CentralFreq.ordinal(), Integer.valueOf(editText_Settings_CentralFreq.getText().toString()));
				m_ComAir5.SetComAir5Property(ComAir5Wrapper.eComAir5PropertyTarget.eComAir5PropertyTarget_Encode.ordinal(), ComAir5Wrapper.eComAir5Property.eComAir5Property_CentralFreq.ordinal(), Integer.valueOf(editText_Settings_CentralFreq.getText().toString()));
			
				//Set iDf to decode and encode.
				m_ComAir5.SetComAir5Property(ComAir5Wrapper.eComAir5PropertyTarget.eComAir5PropertyTarget_Decode.ordinal(), ComAir5Wrapper.eComAir5Property.eComAir5Property_iDfValue.ordinal(), Integer.valueOf(editText_Settings_idf.getText().toString()));
				m_ComAir5.SetComAir5Property(ComAir5Wrapper.eComAir5PropertyTarget.eComAir5PropertyTarget_Encode.ordinal(), ComAir5Wrapper.eComAir5Property.eComAir5Property_iDfValue.ordinal(), Integer.valueOf(editText_Settings_idf.getText().toString()));
				
				//Set threshold to decode
				m_ComAir5.SetComAir5Property(ComAir5Wrapper.eComAir5PropertyTarget.eComAir5PropertyTarget_Decode.ordinal(), ComAir5Wrapper.eComAir5Property.eComAir5Property_Threshold.ordinal(), Integer.valueOf(editText_Settings_threshold.getText().toString()));
				if(bTxMode)
				{
					m_ComAir5.StopComAir5DecodeProcess();
					m_ComAir5.StartComAir5DecodeProcess();
				}
			}
			
		});
		
		m_ComAir5.CalibrateComAir5Recorder();
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}
	
	public void PlayCmdSound(int i32Command)
	{
		if(mPlayer != null)
		{
			mPlayer.stop();
			mPlayer.release();
			mPlayer = null;			
		}
		mPlayer = MediaPlayer.create(this, getResources().getIdentifier("n" + i32Command, "raw", this.getPackageName()));
		mPlayer.setAudioStreamType(AudioManager.STREAM_MUSIC);
		mPlayer.setVolume(2.0f, 2.0f);
		mPlayer.start();
		mPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener() {

			@Override
			public void onCompletion(MediaPlayer arg0) {
				
			}
				
		});

	}
	
	class AutoRunTest extends AsyncTask<Void, Integer, Void> {
		private boolean bRun;
		private int i32TestCmd;
		public AutoRunTest(boolean run)
		{			
			bRun = run;
		}
		@Override
		protected Void doInBackground(Void... arg0) {
			while(bRun)
			{
				try {
					i32TestCmd = Integer.valueOf(textView_Encode_Command.getText().toString());					
					i32TestCmd = (i32TestCmd + 1) % 80;
					publishProgress(i32TestCmd);
					m_ComAir5.PlayComAirCmd(i32TestCmd, 1.0f);										
					Thread.sleep(1500);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
			return null;
		}
		@Override
		protected void onProgressUpdate(Integer... values) {
			// TODO Auto-generated method stub
			textView_Encode_Command.setText(String.valueOf(values[0]));
			if(!bTxMode)
				PlayCmdSound(values[0]);
			
		}
		
	}
}
